/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.adapter;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.ForwardingMappingVisitor;
import org.jetbrains.annotations.Nullable;

public class EmptyElementFilter
extends ForwardingMappingVisitor {
    protected final boolean treatSrcOnDstAsEmpty;
    protected boolean relayHeaderElements;
    protected boolean relayMetadata;
    protected int dstNsCount;
    protected MappedElementKind memberKind;
    protected MappedElementKind localKind;
    protected String classSrcName;
    protected String memberSrcName;
    protected String memberSrcDesc;
    protected String localSrcName;
    protected int localLvIndex;
    protected int argPosition;
    protected int varLvtRowIndex;
    protected int varStartOpIdx;
    protected int varEndOpIdx;
    protected String[] classDstNames;
    protected String[] memberDstNames;
    protected String[] memberDstDescs;
    protected String[] localDstNames;
    protected String classComment;
    protected String memberComment;
    protected String localComment;
    protected boolean forwardClass;
    protected boolean forwardMember;
    protected boolean forwardLocal;
    protected boolean forwardedClass;
    protected boolean forwardedMember;
    protected boolean forwardedLocal;
    protected boolean visitClass;
    protected boolean visitMember;
    protected boolean visitLocal;

    public EmptyElementFilter(MappingVisitor next) {
        this(next, true);
    }

    public EmptyElementFilter(MappingVisitor next, boolean treatSrcOnDstAsEmpty) {
        super(next);
        this.treatSrcOnDstAsEmpty = treatSrcOnDstAsEmpty;
        this.init();
    }

    protected void init() {
        this.relayHeaderElements = false;
        this.relayMetadata = false;
        this.dstNsCount = -1;
        this.memberKind = null;
        this.localKind = null;
        this.classSrcName = null;
        this.memberSrcName = null;
        this.memberSrcDesc = null;
        this.localSrcName = null;
        this.localLvIndex = -1;
        this.argPosition = -1;
        this.varLvtRowIndex = -1;
        this.varStartOpIdx = -1;
        this.varEndOpIdx = -1;
        this.classDstNames = null;
        this.memberDstNames = null;
        this.memberDstDescs = null;
        this.localDstNames = null;
        this.classComment = null;
        this.memberComment = null;
        this.localComment = null;
        this.forwardClass = false;
        this.forwardMember = false;
        this.forwardLocal = false;
        this.forwardedClass = false;
        this.forwardedMember = false;
        this.forwardedLocal = false;
        this.visitClass = true;
        this.visitMember = true;
        this.visitLocal = true;
    }

    @Override
    public void reset() {
        this.init();
        super.reset();
    }

    @Override
    public boolean visitHeader() throws IOException {
        this.relayMetadata = this.relayHeaderElements = super.visitHeader();
        return true;
    }

    @Override
    public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) throws IOException {
        if (this.relayHeaderElements) {
            super.visitNamespaces(srcNamespace, dstNamespaces);
        }
        this.dstNsCount = dstNamespaces.size();
        this.classDstNames = new String[this.dstNsCount];
        this.memberDstNames = new String[this.dstNsCount];
        this.memberDstDescs = new String[this.dstNsCount];
        this.localDstNames = new String[this.dstNsCount];
    }

    @Override
    public void visitMetadata(String key, @Nullable String value) throws IOException {
        if (this.relayMetadata) {
            super.visitMetadata(key, value);
        }
    }

    @Override
    public boolean visitContent() throws IOException {
        this.relayMetadata = super.visitContent();
        return this.relayMetadata;
    }

    @Override
    public boolean visitClass(String srcName) throws IOException {
        this.forwardClass = false;
        this.forwardMember = false;
        this.forwardLocal = false;
        this.forwardedClass = false;
        this.visitClass = true;
        this.classSrcName = srcName;
        Arrays.fill(this.classDstNames, null);
        this.classComment = null;
        return true;
    }

    @Override
    public boolean visitField(String srcName, @Nullable String srcDesc) throws IOException {
        this.memberKind = MappedElementKind.FIELD;
        return this.visitMember(srcName, srcDesc);
    }

    @Override
    public boolean visitMethod(String srcName, @Nullable String srcDesc) throws IOException {
        this.memberKind = MappedElementKind.METHOD;
        return this.visitMember(srcName, srcDesc);
    }

    protected boolean visitMember(String srcName, @Nullable String srcDesc) throws IOException {
        this.forwardMember = false;
        this.forwardLocal = false;
        this.forwardedMember = false;
        this.visitMember = true;
        this.memberSrcName = srcName;
        this.memberSrcDesc = srcDesc;
        Arrays.fill(this.memberDstNames, null);
        Arrays.fill(this.memberDstDescs, null);
        this.memberComment = null;
        return true;
    }

    @Override
    public boolean visitMethodArg(int argPosition, int lvIndex, @Nullable String srcName) throws IOException {
        this.localKind = MappedElementKind.METHOD_ARG;
        this.argPosition = argPosition;
        return this.visitLocal(lvIndex, srcName);
    }

    @Override
    public boolean visitMethodVar(int lvtRowIndex, int lvIndex, int startOpIdx, int endOpIdx, @Nullable String srcName) throws IOException {
        this.localKind = MappedElementKind.METHOD_VAR;
        this.varLvtRowIndex = lvtRowIndex;
        this.varStartOpIdx = startOpIdx;
        this.varEndOpIdx = endOpIdx;
        return this.visitLocal(lvIndex, srcName);
    }

    protected boolean visitLocal(int lvIndex, @Nullable String srcName) throws IOException {
        this.forwardLocal = false;
        this.forwardedLocal = false;
        this.visitLocal = true;
        this.localSrcName = srcName;
        this.localLvIndex = lvIndex;
        Arrays.fill(this.localDstNames, null);
        this.localComment = null;
        return true;
    }

    @Override
    public void visitDstName(MappedElementKind targetKind, int namespace, String name) throws IOException {
        boolean forward = name != null && (!this.treatSrcOnDstAsEmpty || !name.equals(this.getSrcName(targetKind)));
        switch (targetKind) {
            case CLASS: {
                this.forwardClass |= forward;
                this.classDstNames[namespace] = name;
                break;
            }
            case FIELD: 
            case METHOD: {
                this.forwardClass |= forward;
                this.forwardMember |= forward;
                this.memberDstNames[namespace] = name;
                break;
            }
            case METHOD_ARG: 
            case METHOD_VAR: {
                this.forwardClass |= forward;
                this.forwardMember |= forward;
                this.forwardLocal |= forward;
                this.localDstNames[namespace] = name;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown target kind: " + (Object)((Object)targetKind));
            }
        }
    }

    protected String getSrcName(MappedElementKind targetKind) {
        switch (targetKind) {
            case CLASS: {
                return this.classSrcName;
            }
            case FIELD: 
            case METHOD: {
                return this.memberSrcName;
            }
            case METHOD_ARG: 
            case METHOD_VAR: {
                return this.localSrcName;
            }
        }
        throw new IllegalArgumentException("Unknown target kind: " + (Object)((Object)targetKind));
    }

    @Override
    public void visitDstDesc(MappedElementKind targetKind, int namespace, String desc) throws IOException {
        assert (targetKind == this.memberKind);
        boolean forward = desc != null && (!this.treatSrcOnDstAsEmpty || !desc.equals(this.memberSrcDesc));
        this.forwardClass |= forward;
        this.forwardMember |= forward;
        this.memberDstDescs[namespace] = desc;
    }

    @Override
    public boolean visitElementContent(MappedElementKind targetKind) throws IOException {
        this.forward(targetKind);
        return true;
    }

    @Override
    public void visitComment(MappedElementKind targetKind, String comment) throws IOException {
        if (comment == null) {
            return;
        }
        switch (targetKind) {
            case CLASS: {
                this.forwardClass = true;
                this.classComment = comment;
                break;
            }
            case FIELD: 
            case METHOD: {
                this.forwardClass = true;
                this.forwardMember = true;
                this.memberComment = comment;
                break;
            }
            case METHOD_ARG: 
            case METHOD_VAR: {
                this.forwardClass = true;
                this.forwardMember = true;
                this.forwardLocal = true;
                this.localComment = comment;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown target kind: " + (Object)((Object)targetKind));
            }
        }
        this.forward(targetKind);
    }

    protected void forward(MappedElementKind targetKind) throws IOException {
        int i;
        if (this.forwardClass && !this.forwardedClass && this.visitClass && (this.visitClass = super.visitClass(this.classSrcName))) {
            for (i = 0; i < this.dstNsCount; ++i) {
                if (this.classDstNames[i] == null) continue;
                super.visitDstName(MappedElementKind.CLASS, i, this.classDstNames[i]);
            }
            this.visitClass = super.visitElementContent(MappedElementKind.CLASS);
            this.forwardedClass = true;
            if (this.visitClass && this.classComment != null) {
                super.visitComment(MappedElementKind.CLASS, this.classComment);
            }
        }
        if (this.forwardMember && !this.forwardedMember && this.visitClass && this.visitMember) {
            this.visitMember = this.memberKind == MappedElementKind.FIELD ? super.visitField(this.memberSrcName, this.memberSrcDesc) : super.visitMethod(this.memberSrcName, this.memberSrcDesc);
            if (this.visitMember) {
                for (i = 0; i < this.dstNsCount; ++i) {
                    if (this.memberDstNames[i] != null) {
                        super.visitDstName(this.memberKind, i, this.memberDstNames[i]);
                    }
                    if (this.memberDstDescs[i] == null) continue;
                    super.visitDstDesc(this.memberKind, i, this.memberDstDescs[i]);
                }
                this.visitMember = super.visitElementContent(this.memberKind);
                this.forwardedMember = true;
                if (this.visitMember && this.memberComment != null) {
                    super.visitComment(this.memberKind, this.memberComment);
                }
            }
        }
        if (this.forwardLocal && !this.forwardedLocal && this.visitClass && this.visitMember && this.visitLocal) {
            this.visitLocal = this.localKind == MappedElementKind.METHOD_ARG ? super.visitMethodArg(this.argPosition, this.localLvIndex, this.localSrcName) : super.visitMethodVar(this.varLvtRowIndex, this.localLvIndex, this.varStartOpIdx, this.varEndOpIdx, this.localSrcName);
            if (this.visitLocal) {
                for (i = 0; i < this.dstNsCount; ++i) {
                    if (this.localDstNames[i] == null) continue;
                    super.visitDstName(this.localKind, i, this.localDstNames[i]);
                }
                this.visitLocal = super.visitElementContent(this.localKind);
                this.forwardedLocal = true;
                if (this.visitLocal && this.localComment != null) {
                    super.visitComment(this.localKind, this.localComment);
                }
            }
        }
    }

    @Override
    public boolean visitEnd() throws IOException {
        this.init();
        return super.visitEnd();
    }
}

