/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.functionapi.script;

import io.github.cottonmc.functionapi.api.FunctionAPIIdentifier;
import io.github.cottonmc.functionapi.api.script.CommandRunner;
import io.github.cottonmc.functionapi.api.script.ScriptedObject;
import io.github.cottonmc.functionapi.util.impl.FunctionAPIIdentifierImpl;

public abstract class FunctionManager<T, S> {
    protected final FunctionAPIIdentifier functionAPIIdentifier;
    protected final CommandRunner<T, S> commandRunner;
    private final boolean isSingleton;
    private boolean enabled = true;
    protected boolean initialized = false;

    public FunctionManager(ScriptedObject target, String eventName, boolean isSingleton) {
        this(FunctionManager.createID(target, eventName), isSingleton);
    }

    public FunctionManager(ScriptedObject target, String eventName) {
        this(FunctionManager.createID(target, eventName), false);
    }

    public FunctionManager(FunctionAPIIdentifier functionAPIIdentifier) {
        this(functionAPIIdentifier, false);
    }

    public FunctionManager(FunctionAPIIdentifier functionAPIIdentifier, boolean isSingleton) {
        this.functionAPIIdentifier = functionAPIIdentifier;
        this.isSingleton = isSingleton;
        this.commandRunner = this.getCommandRunner(functionAPIIdentifier);
    }

    protected abstract CommandRunner<T, S> getCommandRunner(FunctionAPIIdentifier var1);

    public static FunctionAPIIdentifier createID(ScriptedObject target, String eventName) {
        return new FunctionAPIIdentifierImpl(target.getEventID().getNamespace(), target.getEventType() + "/" + target.getEventID().getPath() + "/" + eventName);
    }

    public void serverInit(S server) {
        if (!this.initialized) {
            this.initialized = true;
        }
    }

    public void fire(T commandContext) {
        if (this.enabled) {
            this.runFunction(commandContext);
        }
    }

    protected abstract void runFunction(T var1);

    protected abstract void runFunctionBlocking(T var1);

    public void fireBlocking(T commandContext) {
        if (this.enabled) {
            this.runFunctionBlocking(commandContext);
        }
    }

    public void markDirty() {
        this.commandRunner.markDirty();
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean hasEvents() {
        if (!this.enabled) {
            return false;
        }
        return this.commandRunner.hasScripts();
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public FunctionAPIIdentifier getID() {
        return this.functionAPIIdentifier;
    }

    public boolean hasEvents(S server) {
        this.commandRunner.reload(server);
        return this.commandRunner.hasScripts();
    }
}

