/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.functionapi.script.commandtemplates;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import io.github.cottonmc.functionapi.api.commands.CommandWithArgument;
import io.github.cottonmc.functionapi.api.commands.CommandWithTwoArguments;
import io.github.cottonmc.functionapi.api.content.block.enums.Direction;
import io.github.cottonmc.functionapi.commands.arguments.FunctionAPIIdentifierArgumentType;

public abstract class InventoryCommandTemplate<S, POS, E, I> {
    private final CommandWithTwoArguments<S, Direction> moveItemFiltered;
    private final CommandWithTwoArguments<S, Direction> moveItemUnFiltered;
    private final CommandWithArgument<S, Direction> consumeItemBlock;
    private final CommandWithArgument<S, Direction> damageItemBlock;
    private final Command<S> damageItemEntity;
    private final Command<S> consumeItemEntity;

    protected abstract ArgumentType<POS> blockPosArgumentType();

    protected abstract ArgumentType<E> getEntityArgumentType();

    protected abstract ArgumentType<I> getitemPredicateArgumentType();

    public InventoryCommandTemplate(CommandWithTwoArguments<S, Direction> moveItemFiltered, CommandWithTwoArguments<S, Direction> moveItemUnFiltered, CommandWithArgument<S, Direction> onsumeItemBlock, CommandWithArgument<S, Direction> damageItemBlock, Command<S> damageItemEntity, Command<S> consumeItemEntity) {
        this.moveItemFiltered = moveItemFiltered;
        this.moveItemUnFiltered = moveItemUnFiltered;
        this.consumeItemBlock = onsumeItemBlock;
        this.damageItemBlock = damageItemBlock;
        this.damageItemEntity = damageItemEntity;
        this.consumeItemEntity = consumeItemEntity;
    }

    public void register(CommandDispatcher<S> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"inventory").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"move").then(this.buildSourceBlockMoveArgument(this.moveItemUnFiltered))).then(this.buildSourceEntityMoveArgument(this.moveItemUnFiltered).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"item", this.getitemPredicateArgumentType()).then(this.buildSourceBlockMoveArgument(this.moveItemFiltered))).then(this.buildSourceEntityMoveArgument(this.moveItemFiltered)))))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"consume").then(RequiredArgumentBuilder.argument((String)"item", this.getitemPredicateArgumentType()).then(this.buildSourceBlockUseArgument(this.consumeItemBlock).then(this.buildSourceEntityUseArgument(this.consumeItemEntity))))).then(LiteralArgumentBuilder.literal((String)"damage").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"item", this.getitemPredicateArgumentType()).then(this.buildSourceBlockUseArgument(this.damageItemBlock))).then(this.buildSourceEntityUseArgument(this.damageItemEntity)))))));
    }

    private ArgumentBuilder<S, LiteralArgumentBuilder<S>> buildTargetBlockMoveArgument(CommandWithTwoArguments<S, Direction> command, Direction sourceDirection) {
        RequiredArgumentBuilder targetBlock = RequiredArgumentBuilder.argument((String)"targetBlock", this.blockPosArgumentType());
        for (Direction value : Direction.values()) {
            targetBlock = (RequiredArgumentBuilder)targetBlock.then(LiteralArgumentBuilder.literal((String)value.name().toLowerCase()).executes(context -> command.execute(context, (Object)sourceDirection, (Object)value)));
        }
        return LiteralArgumentBuilder.literal((String)"block").then((ArgumentBuilder)targetBlock);
    }

    private ArgumentBuilder<S, LiteralArgumentBuilder<S>> buildSourceBlockMoveArgument(CommandWithTwoArguments<S, Direction> command) {
        RequiredArgumentBuilder sourceBlock = RequiredArgumentBuilder.argument((String)"sourceBlock", this.blockPosArgumentType());
        for (Direction value : Direction.values()) {
            sourceBlock = (RequiredArgumentBuilder)sourceBlock.then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)value.name().toLowerCase()).then(this.buildTargetBlockMoveArgument(command, value))).then(LiteralArgumentBuilder.literal((String)"entity").then(RequiredArgumentBuilder.argument((String)"targetEntity", this.getEntityArgumentType()).executes(context -> command.execute(context, (Object)value, null)))));
        }
        return LiteralArgumentBuilder.literal((String)"block").then((ArgumentBuilder)sourceBlock);
    }

    private ArgumentBuilder<S, LiteralArgumentBuilder<S>> buildSourceBlockUseArgument(CommandWithArgument<S, Direction> command) {
        RequiredArgumentBuilder sourceBlock = RequiredArgumentBuilder.argument((String)"sourceBlock", this.blockPosArgumentType());
        for (Direction value : Direction.values()) {
            sourceBlock = (RequiredArgumentBuilder)sourceBlock.then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)value.name().toLowerCase()).then(RequiredArgumentBuilder.argument((String)"eventName", (ArgumentType)FunctionAPIIdentifierArgumentType.Companion.identifier()).executes(context -> command.execute(context, (Object)value)))).executes(context -> command.execute(context, (Object)value)));
        }
        return LiteralArgumentBuilder.literal((String)"block").then((ArgumentBuilder)sourceBlock);
    }

    private ArgumentBuilder<S, LiteralArgumentBuilder<S>> buildSourceEntityMoveArgument(CommandWithTwoArguments<S, Direction> command) {
        return LiteralArgumentBuilder.literal((String)"entity").then(RequiredArgumentBuilder.argument((String)"sourceEntity", this.getEntityArgumentType()).then(LiteralArgumentBuilder.literal((String)"entity").then(RequiredArgumentBuilder.argument((String)"targetEntity", this.getEntityArgumentType()).executes(context -> command.execute(context, null, null)))));
    }

    private ArgumentBuilder<S, LiteralArgumentBuilder<S>> buildSourceEntityUseArgument(Command<S> command) {
        return LiteralArgumentBuilder.literal((String)"entity").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"sourceEntity", this.getEntityArgumentType()).then(RequiredArgumentBuilder.argument((String)"eventName", (ArgumentType)FunctionAPIIdentifierArgumentType.Companion.identifier()).executes(command))).executes(command));
    }
}

