/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.functionapi.script;

import io.github.cottonmc.functionapi.api.FunctionAPIIdentifier;
import io.github.cottonmc.functionapi.api.script.ScriptedObject;
import io.github.cottonmc.functionapi.script.FunctionManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class GlobalFunctionManager<T, S> {
    private Map<FunctionAPIIdentifier, FunctionManager<T, S>> functionManagerMap = new HashMap<FunctionAPIIdentifier, FunctionManager<T, S>>();
    private boolean disabled = false;

    protected GlobalFunctionManager() {
    }

    public void addManager(FunctionManager<T, S> functionManager) {
        FunctionAPIIdentifier eventManagerID = functionManager.getID();
        this.functionManagerMap.put(eventManagerID, functionManager);
        functionManager.markDirty();
        if (this.disabled) {
            functionManager.disable();
        }
    }

    public FunctionManager<T, S> createEvent(ScriptedObject target, String name) {
        return this.addIfMissing(this.getNewManager(target, name));
    }

    public FunctionManager<T, S> createEvent(FunctionAPIIdentifier name) {
        return this.addIfMissing(this.getNewManager(name));
    }

    protected abstract FunctionManager<T, S> getNewManager(FunctionAPIIdentifier var1);

    protected abstract FunctionManager<T, S> getNewManager(ScriptedObject var1, String var2);

    public FunctionManager<T, S> getManager(FunctionAPIIdentifier functionAPIIdentifier) {
        if (!this.functionManagerMap.containsKey(functionAPIIdentifier)) {
            this.createEvent(functionAPIIdentifier);
        }
        return this.functionManagerMap.get(functionAPIIdentifier);
    }

    public Set<FunctionAPIIdentifier> getEventNames() {
        return this.functionManagerMap.keySet();
    }

    public boolean enableEvent(FunctionAPIIdentifier functionAPIIdentifier) {
        FunctionManager<T, S> eventManager = this.functionManagerMap.get(functionAPIIdentifier);
        if (eventManager == null) {
            return false;
        }
        eventManager.enable();
        return true;
    }

    public boolean disableEvent(FunctionAPIIdentifier functionAPIIdentifier) {
        FunctionManager<T, S> eventManager = this.functionManagerMap.get(functionAPIIdentifier);
        if (eventManager == null) {
            return false;
        }
        eventManager.disable();
        return true;
    }

    public void disableAll() {
        this.functionManagerMap.values().parallelStream().forEach(FunctionManager::disable);
        this.disabled = true;
    }

    public void enableAll() {
        this.functionManagerMap.values().parallelStream().forEach(FunctionManager::enable);
        this.disabled = false;
    }

    public void markDirty() {
        this.functionManagerMap.values().forEach(FunctionManager::markDirty);
    }

    public void clean() {
        this.functionManagerMap.clear();
    }

    public boolean containsEvent(FunctionAPIIdentifier eventID) {
        return this.functionManagerMap.containsKey(eventID);
    }

    public FunctionManager<T, S> addIfMissing(FunctionManager<T, S> eventManager) {
        if (!this.containsEvent(eventManager.getID())) {
            this.addManager(eventManager);
            return eventManager;
        }
        return this.functionManagerMap.get(eventManager.getID());
    }

    public boolean executeEvent(ScriptedObject target, String name, T source) {
        FunctionManager<T, S> event = this.createEvent(target, name);
        event.fire(source);
        return event.hasEvents();
    }

    public boolean executeEvent(FunctionAPIIdentifier identifier, T source) {
        FunctionManager<T, S> event = this.createEvent(identifier);
        event.fire(source);
        return event.hasEvents();
    }

    public T executeEventBlocking(ScriptedObject target, String name, T source) {
        this.createEvent(target, name).fireBlocking(source);
        return source;
    }

    public T executeEventBlocking(FunctionAPIIdentifier identifier, T source) {
        this.createEvent(identifier).fireBlocking(source);
        return source;
    }
}

